<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Usuario extends CI_Controller {

        function __construct() {
            parent::__construct();
            date_default_timezone_set('America/Mexico_City');
        }
    
	public function entrar(){
		$this->load->library('session');
		$pass = $this->session->userdata('wrong_pass');
		$this->load->helper("url");
		$this->load->view("header_2");
		$this->load->view('login', array('pass'=>$pass));
		$this->load->view("footer");
	}

	public function login(){

		$this->load->library("form_validation");
		$this->load->model('UsuarioModel');
		$this->load->helper("security");

		$this->form_validation->set_rules('correo', 'Correo', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required');

		if ($this->form_validation->run() == FALSE){

			$this->load->view('registro_usuario');

		}else{
			$usuario = $this->UsuarioModel->login( $this->input->post("correo"), $this->input->post( "password" ) );
			if( $usuario ){
				$this->load->library('session');
				$id_estudiante = ( isset( $usuario[0]->idEstudiante ) ) ? $usuario[0]->idEstudiante : 0;
				$newdata = array(
                   'Nombre'  => $usuario[0]->nombres,
                   'id_estudiante' => $id_estudiante,
                   'rol' => $usuario[0]->rol,
                   'idUsuario' => $usuario[0]->idUsuario,
                   'nivel' => ( isset( $usuario[0]->nivel ) ) ? $usuario[0]->nivel : 0,
               );

				$this->session->set_userdata($newdata);

				if( $usuario[0]->rol === '0' or $usuario[0]->rol === '3' ){
					redirect('/admin');
				}elseif ( $usuario[0]->rol === '1') {
					redirect('/usuario/menu_principal');
				}else{
					redirect(base_url());
				}


			}else {
				$this->load->library('session');
				$wrong_pass = array('wrong_pass'=>1);
				$this->session->set_userdata($wrong_pass);
				redirect('/usuario/entrar');
			}
		}

	}
        
        public function salir(){
		$this->load->library('session');
		$this->session->sess_destroy();
		redirect(base_url());
	}

//------------------------ GENERAL ---------------------------//
        
        public function menu_principal(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$show_snap=false;
			$show_beck1=false;
			$show_beck2=false;
			$show_edi=false;
			$show_assist=false;
                        
                        $show_apgar=false;

			$query = $this->db->query('SELECT termino FROM  AssitTerminada WHERE idEstudiante = '.$this->session->userdata('id_estudiante'));

			$query_result = $query->result();

			$this->load->model("usuariomodel");

			$id_estudiante = $this->session->userdata('id_estudiante');

			if( $this->usuariomodel->contesto_escala( $id_estudiante , 8 ) ){
				$show_snap=true;
			}
			if( $this->usuariomodel->contesto_escala( $id_estudiante , 7 ) ){
				$show_beck1=true;
			}
			if( $this->usuariomodel->contesto_escala( $id_estudiante , 9 ) ){
				$show_beck2=true;
			}
			if( $this->usuariomodel->contesto_escala( $id_estudiante , 10 ) ){
				$show_edi=true;
			}
			if(
				$this->usuariomodel->contesto_escala( $id_estudiante , 18 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 19 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 20 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 21 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 22 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 23 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 24 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 25 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 26 )||
				$this->usuariomodel->contesto_escala( $id_estudiante , 27 )||
				isset($query_result[0]->termino)
			){
				$show_assist=true;
			}
                        if( $this->usuariomodel->contesto_escala( $id_estudiante , 29 ) ){
				$show_apgar=true;
			}
                        

			$this->load->model('UsuarioModel');
			$escala = 'default';
			$username = $this->session->userdata('Nombre');
			$nivel = $this->session->userdata('nivel');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('menu_principal', array(
				'show_snap'=>$show_snap,
				'show_beck1'=>$show_beck1,
				'show_beck2'=>$show_beck2,
				'show_edi'=>$show_edi,
				'show_assist'=>$show_assist,
                                'show_apgar'=>$show_apgar,
				'nivel'=>$nivel));
			$this->load->view('footer');
			if(!$this->UsuarioModel->tiene_edad_y_sexo($this->session->userdata('idUsuario'))){
				$this->load->view('edadysexo');
			}

		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_snap_secundaria(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){                       
			$this->load->model("usuariomodel");
                        $this->load->model('fases');
                        $id_estudiante = $this->session->userdata('id_estudiante');
                        $id_transtorno_tdah = 8;
                        $fase=0;
                        if($this->fases->fase_terminada($id_estudiante, $id_transtorno_tdah, "1")) $fase=1;
                        if($this->fases->fase_terminada($id_estudiante, $id_transtorno_tdah, "2")) $fase=2;
                        if($this->fases->fase_terminada($id_estudiante, $id_transtorno_tdah, "3")) $fase=3;
                        switch($fase)
                        {
                            case 0:
                                $escala = "tdah";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('TDAH/cuestionario_tdah_s');
				$this->load->view('footer');
                                break;
                            case 1: redirect(base_url().'index.php/usuario/modulo_snap_secundaria_2'); 
                                break;
                            case 2: redirect(base_url().'index.php/usuario/modulo_snap_secundaria_3');
                                break;
                            case 3: 
                                $escala = "tdah";
				$sesion = "snap";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ya_contestada', array('la_sesion' => $sesion));
				$this->load->view('footer');
                                break;
                        }                        

		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_snap_secundaria_2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('TDAH/cuestionario_tdah_s2');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_snap_secundaria_3(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('TDAH/cuestionario_tdah_s3');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
        
        public function sesion_educativa_snap(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('TDAH/sesion_snap');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_beck1(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$this->load->model("usuariomodel");
			if( $this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 7 ) ){
				$escala = "beck1";
				$sesion = "beck1";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ya_contestada', array('la_sesion' => $sesion));
				$this->load->view('footer');
				//redirect(base_url().'index.php/usuario/menu_principal');
			}else{
				$username = $this->session->userdata('Nombre');
				$escala = "beck1";
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('BECK1/cuestionario_beck1');
				$this->load->view('footer');

			}
		}else{
			redirect(base_url());
		}
	}
        
        public function sesion_educativa_beck1(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck1";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('BECK1/sesion_beck1');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
                
        public function modulo_edi(){
		if($this->session->userdata('rol') === '1'|| $this->session->userdata('rol') === '0'){
			$this->load->model("usuariomodel");
                        $escala = "edi";
                        $username = $this->session->userdata('Nombre');
                        $this->load->view('header', array('la_escala' => $escala,'username'=>$username));
                        switch($this->usuariomodel->get_pagina_actual_edi($this->session->userdata('id_estudiante')))
                        {
                         case 0:  $sesion = "edi";				
				
				$this->load->view('ya_contestada', array('la_sesion' => $sesion));
				
                             break; 
                         case 1:
                                $this->session->set_userdata('c_id',0);
				$this->session->set_userdata('c_sb',0);
				$this->session->set_userdata('c_ic',0);
				$this->session->set_userdata('c_iba',0);
				$this->session->set_userdata('c_p',0);
				$this->session->set_userdata('c_di',0);
				$this->session->set_userdata('c_ci',0);
				$this->session->set_userdata('c_mm',0);
                                $this->load->view('EDI/cuestionario_edi');
                             break;
                         case 2:
                                $this->session->set_userdata('c_id',2);
				$this->session->set_userdata('c_sb',2);
				$this->session->set_userdata('c_ic',2);
				$this->session->set_userdata('c_iba',1);
				$this->session->set_userdata('c_p',0);
				$this->session->set_userdata('c_di',0);
				$this->session->set_userdata('c_ci',1);
				$this->session->set_userdata('c_mm',2);
                                $this->load->view('EDI/cuestionario_edi_2');
                             break;
                         case 3:
                                $this->session->set_userdata('c_id',4);
				$this->session->set_userdata('c_sb',2);
				$this->session->set_userdata('c_ic',4);
				$this->session->set_userdata('c_iba',3);
				$this->session->set_userdata('c_p',1);
				$this->session->set_userdata('c_di',2);
				$this->session->set_userdata('c_ci',1);
				$this->session->set_userdata('c_mm',3);
                                $this->load->view('EDI/cuestionario_edi_3');
                             break;
                        case 4:
                                $this->session->set_userdata('c_id',5);
				$this->session->set_userdata('c_sb',3);
				$this->session->set_userdata('c_ic',4);
				$this->session->set_userdata('c_iba',5);
				$this->session->set_userdata('c_p',2);
				$this->session->set_userdata('c_di',4);
				$this->session->set_userdata('c_ci',3);
				$this->session->set_userdata('c_mm',4);
                                $this->load->view('EDI/cuestionario_edi_4');
                             break; 
                        case 5:
                                $this->session->set_userdata('c_id',6);
				$this->session->set_userdata('c_sb',4);
				$this->session->set_userdata('c_ic',5);
				$this->session->set_userdata('c_iba',6);
				$this->session->set_userdata('c_p',3);
				$this->session->set_userdata('c_di',5);
				$this->session->set_userdata('c_ci',5);
				$this->session->set_userdata('c_mm',6);
                                $this->load->view('EDI/cuestionario_edi_5');
                             break;  
                        case 6:
                                $this->session->set_userdata('c_id',7);
				$this->session->set_userdata('c_sb',5);
				$this->session->set_userdata('c_ic',6);
				$this->session->set_userdata('c_iba',9);
				$this->session->set_userdata('c_p',4);
				$this->session->set_userdata('c_di',5);
				$this->session->set_userdata('c_ci',7);
				$this->session->set_userdata('c_mm',7);
                                $this->load->view('EDI/cuestionario_edi_6');
                             break;   
                        }
                        $this->load->view('footer');                                              
		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_edi_2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('EDI/cuestionario_edi_2');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_edi_3(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('EDI/cuestionario_edi_3');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_edi_4(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('EDI/cuestionario_edi_4');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_edi_5(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('EDI/cuestionario_edi_5');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_edi_6(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('EDI/cuestionario_edi_6');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function sesion_educativa_edi(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('EDI/sesion_edi');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_beck2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$this->load->model("usuariomodel");
			if( $this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 9 ) ){
				$escala = "beck2";
				$sesion = "beck2";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ya_contestada', array('la_sesion' => $sesion));
				$this->load->view('footer');
				//redirect(base_url().'index.php/usuario/menu_principal');
			}else{
				$escala = "beck2";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('BECK2/cuestionario_beck2');
				$this->load->view('footer');

			}
		}else{
			redirect(base_url());
		}
	}
	public function sesion_educativa_beck2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck2";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('BECK2/sesion_beck2');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_assist(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			//Consulta para saber si ya se terminó Assist
			$query = $this->db->query('SELECT termino FROM  AssitTerminada WHERE idEstudiante = '.$this->session->userdata('id_estudiante'));
			$query_result = $query->result();
			$this->load->model("usuariomodel");
			if(
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 18 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 19 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 20 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 21 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 22 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 23 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 24 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 25 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 26 )||
				$this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 27 )||
				isset($query_result[0]->termino)
				){
				$escala = "assist";
				$sesion = "assist";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ya_contestada', array('la_sesion' => $sesion));
				$this->load->view('footer');
				//redirect(base_url().'index.php/usuario/menu_principal');
			}else{
				$escala = "assist";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ASSIST/cuestionario_assist');
				$this->load->view('footer');

			}
		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_assist_tabaco(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_tabaco');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_alcohol(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_alcohol');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_mariguana(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_mariguana');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_cocaina(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_cocaina');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_anfetaminas(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_anfetaminas');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_inhalables(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_inhalables');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_tranquilizantes(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_tranquilizantes');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_alucinogenos(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_alucinogenos');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_opiaceos(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_assist_opiaceos');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_assist_otros(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
                        $otros = $this->session->userdata('assist_otro');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username,'otros'=>$otros));
			$this->load->view('ASSIST/cuestionario_assist_otros');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function sesion_educativa_assist(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/sesion_assist');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
        
        
        public function modulo_apgar(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){                       
			$this->load->model("usuariomodel");
                        
                       // $id_estudiante = $this->session->userdata('id_estudiante');
                        $this->load->model("usuariomodel");
                        $escala = "apgar";
			if( $this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 29 ) ){
				
				$sesion = "apgar";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ya_contestada', array('la_sesion' => $sesion,'hide_sesion_educativa'=>1));
				$this->load->view('footer');
				//redirect(base_url().'index.php/usuario/menu_principal');
			}else{				
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('APGAR/cuestionario_apgar');
				$this->load->view('footer');

			}
		}else{
			redirect(base_url());
		}
	}
        
        
        public function modulo_autolesionismo(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){                       
			$this->load->model("usuariomodel");
                        
                       // $id_estudiante = $this->session->userdata('id_estudiante');
                        $this->load->model("usuariomodel");
                        $escala = "autolesionismo";
			if( $this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 30 ) ){
				
				$sesion = "apgar";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ya_contestada', array('la_sesion' => $sesion,'hide_sesion_educativa'=>1));
				$this->load->view('footer');
				//redirect(base_url().'index.php/usuario/menu_principal');
			}else{				
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('AUTOLESIONISMO/cuestionario');
				$this->load->view('footer');

			}
		}else{
			redirect(base_url());
		}
	}
        
        public function modulo_violencia(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){                       
			$this->load->model("usuariomodel");
                        
                       // $id_estudiante = $this->session->userdata('id_estudiante');
                        $this->load->model("usuariomodel");
                        $escala = "violencia";
			if( $this->usuariomodel->contesto_escala( $this->session->userdata('id_estudiante') , 31 ) ){
				
				$sesion = "violencia";
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('ya_contestada', array('la_sesion' => $sesion,'hide_sesion_educativa'=>1));
				$this->load->view('footer');
				//redirect(base_url().'index.php/usuario/menu_principal');
			}else{				
				$username = $this->session->userdata('Nombre');
				$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
				$this->load->view('Violencia/cuestionario_violencia');
				$this->load->view('footer');

			}
		}else{
			redirect(base_url());
		}
	}
        
        
        /**************************************************************/
        /**************************************************************/
        /**************************************************************/
        /**************************************************************/
        
        
        
        
        
        
        
        
        
	public function escala_terminada(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$this->load->library('session');
			$escala = $this->session->flashdata('tipo_escala');
			$escala2 = $escala;
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('fin_escala', array('la_escala' => $escala, 'la_escala2' => $escala2));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function cuestionario(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$username = $this->session->userdata('Nombre');
			$this->load->view('header',array('username'=>$username));
			$this->load->view('cuestionario_final', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	

	

	public function edadysexo(){
		$this->load->library('session');
		$edad = $this->input->post('edad');
		$sexo = $this->input->post('sexo');

		$data = array(
			'sexo' => $sexo,
			'edad' => $edad
		);
		$this->db->where('idUsuario', $this->session->userdata('idUsuario'));
		$this->db->update('Usuario', $data);
		redirect(base_url().'index.php/usuario/menu_principal');
	}


	
	
	public function modulo_snap_preparatoria(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('TDAH/cuestionario_tdah_p');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function modulo_snap_preparatoria_2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('TDAH/cuestionario_tdah_p2');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	

	public function cuestionario_snap(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('TDAH/cuestionario_final_snap');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function aprobado_snap(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$escala2 = "snap";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('approved', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function fallado_snap(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "tdah";
			$escala2 = "snap";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('failed', array('la_escala2' => $escala2));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}


//------------------------ BECK1 - ANSIEDAD ---------------------------//
	
	
	public function cuestionario_beck1(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck1";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('BECK1/cuestionario_final_beck1');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function aprobado_beck1(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck1";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('approved', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function fallado_beck1(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck1";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('failed', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

//------------------------ BECK2 - DEPRESIÓN ---------------------------//
	
	public function cuestionario_beck2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck2";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('BECK2/cuestionario_final_beck2');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function aprobado_beck2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck2";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('approved', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function fallado_beck2(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "beck2";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('failed', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

//------------------------ EDI - TRASTORNOS ALIMENTICIOS ---------------------------//

	
	
	
	public function cuestionario_edi(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('EDI/cuestionario_final_edi');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	
	function aprobado_edi(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('approved', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function fallado_edi(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "edi";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('failed', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

//------------------------ ASSIST - DROGAS ---------------------------//
	
	
	public function cuestionario_assist(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('ASSIST/cuestionario_final_assist');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function aprobado_assist(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('approved', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function fallado_assist(){
		if($this->session->userdata('rol') === '1' || $this->session->userdata('rol') === '0'){
			$escala = "assist";
			$username = $this->session->userdata('Nombre');
			$this->load->view('header', array('la_escala' => $escala,'username'=>$username));
			$this->load->view('failed', array('la_escala' => $escala));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function contesto_encuesta(){
		$this->db->query('INSERT INTO
			`db576215382`.`CuestionarioContestado` (`contestado`, `idCuestionarioContestado`, `idEstudiante`, `Escala`)
			VALUES (\'1\', NULL, \''.$this->input->post("idEstudiante").'\', \''.$this->input->post("escala").'\');');
	}




}
